<?php
class AvgStatement extends PDOStatement {
    public function avg() {
        $sum = 0;
        $vars = get_object_vars($this);
        // Usunicie wbudowanej zmiennej 'queryString' klasy PDOStatement 
        unset($vars['queryString']);
        foreach ($vars as $var => $value) {
            $sum += strlen($value);
        }
        return $sum / count($vars);
    }
}

$row = new AvgStatement;
$db = new PDO('sqlite:/usr/local/zodiac');
$results = $db->query('SELECT sign,planet FROM zodiac',PDO::FETCH_INTO, $row);
// Kade wywoanie metody fetch() powoduje przypisanie wartoci zmiennej $row
while ($results->fetch()) {
    print "Znak $row->sign odpowiada planecie $row->planet (rednia: {$row->avg()}) <br/>\n";
}
?>
